mEmitSpeed = 50;
mMaxParticles = 50;

---------------------------
-- Initialization phase

-- Define our custom particle properties
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member
pFrames = Allocate(1);

-- Set the particle texture
SetTexture("sparkly_party.png");

-- Set the blend mode
SetBlendMode(kBlendNormal);
-- Set the size of the particle pool.
SetNumParticles(mMaxParticles);
-- ------------------------------------------------------------
-- Action Phase

-- Define dLocus for FluidFX; in the game it's defined in 
-- swarm.cpp as a data source, and it gets the mouse position.
if not dLocus then
   dLocus= Vec2(0,0) ; 
end

dScale = Vec2(0.2, 0.2);

-- Start color (tint) off as white (natural color of image)
pColor:Init( Color(1,1,1,1) );
-- Start scale out as 0.5
pScale:Init( dScale[1] * 5);

--pSpin:Init(1);
pSpinSpeed:Init(fRange(1, 3));
pFrames:Init(1);

pPosition:Init( ( fRange( Vec2(-100,-100), Vec2(100,100) ) * dScale[1] ) + dLocus );
pVelocity:Init( fRange( Vec2(-50,-50), Vec2(50,-50) ) );
pAge:Init(0);
pSpin:Init( fRange( 0, 2*3.1415927 ) );
pSpinSpeed:Init( fRange( -3, 3 ) );

-- ------------------------------------------------------------
-- Particle Parameter Animation Functions
--pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

--pVelocity:Anim( f2dRotation( pSpin )  );
pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,250)) );
--pPosition:Anim( pPosition - Vec2(pVelocity[1], pVelocity[2]*0.5) * 0.3);
pPosition:Anim( pPosition + fTimeScale(pVelocity) );

pUp:Anim( f2dRotation( pSpin ) );

pAge:Anim( pAge+fAge() );
Anim( fExpire( fGreater(pAge,500) ) );

--CreateParticles(50);
function Update(seconds)
	if seconds < 0.25 then
		CreateParticles( seconds * mEmitSpeed );
	end
end

